%-------------------------------------------------------------------------%
% Copyright (c) 2017 Modenese L.                                          %
%                                                                         %
% Licensed under the Apache License, Version 2.0 (the "License");         %
% you may not use this file except in compliance with the License.        %
% You may obtain a copy of the License at                                 %
% http://www.apache.org/licenses/LICENSE-2.0.                             %
%                                                                         %
% Unless required by applicable law or agreed to in writing, software     %
% distributed under the License is distributed on an "AS IS" BASIS,       %
% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or         %
% implied. See the License for the specific language governing            %
% permissions and limitations under the License.                          %
%                                                                         %
%    Author: Luca Modenese, October 2017                                  %
%    email:    l.modenese@sheffield.ac.uk                                 %
%-------------------------------------------------------------------------%
%
% This function rotates the Markers in acquisition acq using the rotation
% matrix specified
function acq_rotate = rotateMarkerData(acq, RotMat)

%clone the acquisition
acq_rotate = btkCloneAcquisition(acq);

for  n_Marker = 1:btkGetPointNumber(acq)
    % set as marker values the rotated trajectories
    btkSetPoint(acq_rotate, n_Marker, (RotMat*btkGetPoint(acq,n_Marker)')');
end

end